SET SQL_SAFE_UPDATES=0;


SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_FATHER_ABSENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE (T7.isDeceased is null OR T7.isDeceased=FALSE) AND 
T1.id IN (namedParams) AND T2.attendanceStatus = 'PRESENT' AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'FATHER' " WHERE `dataProviderId`=@dtproviderId;


SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_MOTHER_ABSENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE (T7.isDeceased is null OR T7.isDeceased=FALSE) AND 
T1.id IN (namedParams) AND T2.attendanceStatus = 'PRESENT' AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'MOTHER' " WHERE `dataProviderId`=@dtproviderId;


SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_MARKED_PRESENT_CD_MS_FATHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
      LEFT JOIN
    multi_language ml on T5.correspondence_language=ml.id  
WHERE (T7.isDeceased is null OR T7.isDeceased=FALSE) AND 
T1.id IN (namedParams) AND T2.attendanceStatus = 'PRESENT' AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'FATHER' AND T6.whetherDeleted = false " WHERE `dataProviderId`=@dtproviderId;

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_MARKED_PRESENT_CD_MS_MOTHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
      LEFT JOIN
    multi_language ml on T5.correspondence_language=ml.id   
WHERE (T7.isDeceased is null OR T7.isDeceased=FALSE) AND 
T1.id IN (namedParams) AND T2.attendanceStatus = 'PRESENT' AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'MOTHER' AND T6.whetherDeleted = false " WHERE `dataProviderId`=@dtproviderId;

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_WEEKLY_ATTENDANCE_PARENTS_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="select 
tmp1.ID as ID,
tmp1.TOTAL_PRESENT as `TOTAL_PRESENT`,
tmp1.TOTAL_ABSENT as `TOTAL_ABSENT`,
tmp1.PRESENT_PERCENTAGE as `PRESENT_PERCENTAGE`,
tmp1.ABSENT_PERCENTAGE as `ABSENT_PERCENTAGE`,
tmp1.FIRST_NAME as `FIRST_NAME`,
tmp1.LAST_NAME as `LAST_NAME`,
tmp1.MOBILE_NO as `MOBILE_NO`,
tmp1.EMAIL_ID as `EMAIL_ID`,
tmp1.MOBILE_CODE as `MOBILE_CODE`,
tmp1.LANGUAGE_KEY as `LANGUAGE_KEY`,
IFNULL(tmp2.DATE, DATE_FORMAT(subdate(now(),7),'%Y-%m-%d')) as `DATE1`,
IF(tmp2.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp2.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp2.DATEDETAILS),2)),'_',' ')) as `DATE1DETAILS`,
IFNULL(tmp3.DATE, DATE_FORMAT(subdate(now(),6),'%Y-%m-%d')) as `DATE2`,
IF(tmp3.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp3.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp3.DATEDETAILS),2)),'_',' ')) as `DATE2DETAILS`,
IFNULL(tmp4.DATE, DATE_FORMAT(subdate(now(),5),'%Y-%m-%d')) as `DATE3`,
IF(tmp4.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp4.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp4.DATEDETAILS),2)),'_',' ')) as `DATE3DETAILS`,
IFNULL(tmp5.DATE, DATE_FORMAT(subdate(now(),4),'%Y-%m-%d')) as `DATE4`,
IF(tmp5.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp5.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp5.DATEDETAILS),2)),'_',' ')) as `DATE4DETAILS`,
IFNULL(tmp6.DATE, DATE_FORMAT(subdate(now(),3),'%Y-%m-%d')) as `DATE5`,
IF(tmp6.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp6.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp6.DATEDETAILS),2)),'_',' ')) as `DATE5DETAILS`,
IFNULL(tmp7.DATE, DATE_FORMAT(subdate(now(),2),'%Y-%m-%d')) as `DATE6`,
IF(tmp7.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp7.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp7.DATEDETAILS),2)),'_',' ')) as `DATE6DETAILS`,
IFNULL(tmp8.DATE, DATE_FORMAT(subdate(now(),1),'%Y-%m-%d')) as `DATE7`,
IF(tmp8.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp8.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp8.DATEDETAILS),2)),'_',' ')) as `DATE7DETAILS`
from 
(
select T3.studentId as `ID`,
count(IF(T2.attendanceStatus = 'PRESENT',T2.attendanceStatus,null)) as `TOTAL_PRESENT`,
count(IF(T2.attendanceStatus <> 'PRESENT',T2.attendanceStatus,null)) as `TOTAL_ABSENT`,
ROUND((count(IF(T2.attendanceStatus = 'PRESENT',T2.attendanceStatus,null))/
	(count(IF(T2.attendanceStatus = 'PRESENT',T2.attendanceStatus,null))
    +count(IF(T2.attendanceStatus <> 'PRESENT',T2.attendanceStatus,null))))*100) as `PRESENT_PERCENTAGE`,
ROUND((count(IF(T2.attendanceStatus <> 'PRESENT',T2.attendanceStatus,null))/
	(count(IF(T2.attendanceStatus = 'PRESENT',T2.attendanceStatus,null))
    +count(IF(T2.attendanceStatus <> 'PRESENT',T2.attendanceStatus,null))))*100) as `ABSENT_PERCENTAGE`,
T6.firstName as `FIRST_NAME`,
T6.lastName as `LAST_NAME`,
T6.mobileNumber as `MOBILE_NO`,
T6.mobileCountryCode as `MOBILE_CODE`,
T6.emailId as `EMAIL_ID`,
ml.code as LANGUAGE_KEY
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId 
LEFT JOIN multi_language ml on T5.correspondence_language=ml.id
inner join persons T6 on T6.id =
( 
	SELECT T7.relatedPersonId from person_relationships T7
	where T7.personId = T5.id AND T7.relationship = 
		case
			when exists (select T8.relationship from person_relationships T8 where T8.personId = T5.id and T8.relationship='LOCAL_GUARDIAN') then 'LOCAL_GUARDIAN'
			when exists (select T8.relationship from person_relationships T8 where T8.personId = T5.id and T8.relationship='GUARDIAN') then 'GUARDIAN'
			when exists (select T8.relationship from person_relationships T8 where T8.personId = T5.id and T8.relationship='FATHER') then 'FATHER'
			when exists (select T8.relationship from person_relationships T8 where T8.personId = T5.id and T8.relationship='MOTHER') then 'MOTHER'
		end
)
where (T6.isDeceased is null OR T6.isDeceased=FALSE) AND T3.studentId in (namedParams) 
and (T1.dateOfAttendance BETWEEN DATE_FORMAT(SUBDATE(NOW(),7),'%Y-%m-%d') AND DATE_FORMAT(NOW(),'%Y-%m-%d'))
group by T3.studentId
order by T3.studentId
) tmp1
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),7),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),7),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp2 on tmp2.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),6),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),6),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp3 on tmp3.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),5),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),5),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp4 on tmp4.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),4),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),4),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp5 on tmp5.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),3),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),3),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp6 on tmp6.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),2),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),2),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp7 on tmp7.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),1),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),1),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp8 on tmp8.studentId = tmp1.`ID` " WHERE `dataProviderId`=@dtproviderId;

    
SET SQL_SAFE_UPDATES=1;